/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateDeviceRequestModelMarshaller {
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").isBinary(false).build();
    private static final UpdateDeviceRequestModelMarshaller INSTANCE = new UpdateDeviceRequestModelMarshaller();

    private UpdateDeviceRequestModelMarshaller() {
    }

    public static UpdateDeviceRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateDeviceRequest updateDeviceRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateDeviceRequest), (String)"updateDeviceRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateDeviceRequest.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall((Object)updateDeviceRequest.deviceName(), DEVICENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

