/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.UserData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserDataMarshaller {
    private static final MarshallingInfo<String> USERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserArn").isBinary(false).build();
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").isBinary(false).build();
    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").isBinary(false).build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").isBinary(false).build();
    private static final MarshallingInfo<String> ENROLLMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnrollmentStatus").isBinary(false).build();
    private static final MarshallingInfo<String> ENROLLMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnrollmentId").isBinary(false).build();
    private static final UserDataMarshaller INSTANCE = new UserDataMarshaller();

    private UserDataMarshaller() {
    }

    public static UserDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserData userData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userData, (String)"userData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userData.userArn(), USERARN_BINDING);
            protocolMarshaller.marshall((Object)userData.firstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall((Object)userData.lastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall((Object)userData.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)userData.enrollmentStatusAsString(), ENROLLMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)userData.enrollmentId(), ENROLLMENTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

