/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information related to a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactData implements SdkPojo, Serializable, ToCopyableBuilder<ContactData.Builder, ContactData> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContactData::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContactData::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContactData::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContactData::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ContactData::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD,
            DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactArn;

    private final String displayName;

    private final String firstName;

    private final String lastName;

    private final String phoneNumber;

    private ContactData(BuilderImpl builder) {
        this.contactArn = builder.contactArn;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
    }

    /**
     * <p>
     * The ARN of the contact.
     * </p>
     * 
     * @return The ARN of the contact.
     */
    public String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The name of the contact to display on the console.
     * </p>
     * 
     * @return The name of the contact to display on the console.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The first name of the contact, used to call the contact on the device.
     * </p>
     * 
     * @return The first name of the contact, used to call the contact on the device.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the contact, used to call the contact on the device.
     * </p>
     * 
     * @return The last name of the contact, used to call the contact on the device.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The phone number of the contact.
     * </p>
     * 
     * @return The phone number of the contact.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactData)) {
            return false;
        }
        ContactData other = (ContactData) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(phoneNumber(), other.phoneNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("ContactData").add("ContactArn", contactArn()).add("DisplayName", displayName())
                .add("FirstName", firstName()).add("LastName", lastName()).add("PhoneNumber", phoneNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactData, T> g) {
        return obj -> g.apply((ContactData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactData> {
        /**
         * <p>
         * The ARN of the contact.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The name of the contact to display on the console.
         * </p>
         * 
         * @param displayName
         *        The name of the contact to display on the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The first name of the contact, used to call the contact on the device.
         * </p>
         * 
         * @param firstName
         *        The first name of the contact, used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the contact, used to call the contact on the device.
         * </p>
         * 
         * @param lastName
         *        The last name of the contact, used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The phone number of the contact.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);
    }

    static final class BuilderImpl implements Builder {
        private String contactArn;

        private String displayName;

        private String firstName;

        private String lastName;

        private String phoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactData model) {
            contactArn(model.contactArn);
            displayName(model.displayName);
            firstName(model.firstName);
            lastName(model.lastName);
            phoneNumber(model.phoneNumber);
        }

        public final String getContactArn() {
            return contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public ContactData build() {
            return new ContactData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
