/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException;
import software.amazon.awssdk.services.alexaforbusiness.model.AlreadyExistsException;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidUserStatusException;
import software.amazon.awssdk.services.alexaforbusiness.model.LimitExceededException;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NameInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.NotFoundException;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPaginator;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing null. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Alexa for Business makes it easy for you to use Alexa in your organization. Alexa for Business gives you the tools
 * you need to manage Alexa devices, enroll your users, and assign skills, at scale. You can build your own
 * context-aware voice skills using the Alexa Skills Kit, and the Alexa for Business APIs, and you can make these
 * available as private skills for your organization. Alexa for Business also makes it easy to voice-enable your
 * products and services, providing context-aware voice experiences for your customers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AlexaForBusinessClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "a4b";

    /**
     * Create a {@link AlexaForBusinessClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static AlexaForBusinessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AlexaForBusinessClient}.
     */
    static AlexaForBusinessClientBuilder builder() {
        return new DefaultAlexaForBusinessClientBuilder();
    }

    /**
     * <p>
     * Associates a device to a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or a manual
     * sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithRoomResponse associateDeviceWithRoom(AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest)
            throws LimitExceededException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device to a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or a manual
     * sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithRoomResponse associateDeviceWithRoom(
            Consumer<AssociateDeviceWithRoomRequest.Builder> associateDeviceWithRoomRequest) throws LimitExceededException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return associateDeviceWithRoom(AssociateDeviceWithRoomRequest.builder().apply(associateDeviceWithRoomRequest).build());
    }

    /**
     * <p>
     * Associates a skill group to a given room. This enables all skills in the associated skill group on all devices in
     * the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill group to a given room. This enables all skills in the associated skill group on all devices in
     * the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            Consumer<AssociateSkillGroupWithRoomRequest.Builder> associateSkillGroupWithRoomRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return associateSkillGroupWithRoom(AssociateSkillGroupWithRoomRequest.builder().apply(associateSkillGroupWithRoomRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws LimitExceededException,
            AlreadyExistsException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws LimitExceededException, AlreadyExistsException, SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        return createProfile(CreateProfileRequest.builder().apply(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoomResponse createRoom(Consumer<CreateRoomRequest.Builder> createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return createRoom(CreateRoomRequest.builder().apply(createRoomRequest).build());
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSkillGroupResponse createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSkillGroupResponse createSkillGroup(Consumer<CreateSkillGroupRequest.Builder> createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        return createSkillGroup(CreateSkillGroupRequest.builder().apply(createSkillGroupRequest).build());
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceInUseException,
            LimitExceededException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws ResourceInUseException,
            LimitExceededException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return createUser(CreateUserRequest.builder().apply(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return deleteProfile(DeleteProfileRequest.builder().apply(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoomResponse deleteRoom(Consumer<DeleteRoomRequest.Builder> deleteRoomRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return deleteRoom(DeleteRoomRequest.builder().apply(deleteRoomRequest).build());
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) throws SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            Consumer<DeleteRoomSkillParameterRequest.Builder> deleteRoomSkillParameterRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return deleteRoomSkillParameter(DeleteRoomSkillParameterRequest.builder().apply(deleteRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillGroupResponse deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSkillGroupResponse deleteSkillGroup(Consumer<DeleteSkillGroupRequest.Builder> deleteSkillGroupRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return deleteSkillGroup(DeleteSkillGroupRequest.builder().apply(deleteSkillGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return deleteUser(DeleteUserRequest.builder().apply(deleteUserRequest).build());
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) throws SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            Consumer<DisassociateDeviceFromRoomRequest.Builder> disassociateDeviceFromRoomRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return disassociateDeviceFromRoom(DisassociateDeviceFromRoomRequest.builder().apply(disassociateDeviceFromRoomRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            Consumer<DisassociateSkillGroupFromRoomRequest.Builder> disassociateSkillGroupFromRoomRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        return disassociateSkillGroupFromRoom(DisassociateSkillGroupFromRoomRequest.builder()
                .apply(disassociateSkillGroupFromRoomRequest).build());
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return getDevice(GetDeviceRequest.builder().apply(getDeviceRequest).build());
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProfileResponse getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return getProfile(GetProfileRequest.builder().apply(getProfileRequest).build());
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRoomResponse getRoom(Consumer<GetRoomRequest.Builder> getRoomRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return getRoom(GetRoomRequest.builder().apply(getRoomRequest).build());
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRoomSkillParameterResponse getRoomSkillParameter(GetRoomSkillParameterRequest getRoomSkillParameterRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRoomSkillParameterResponse getRoomSkillParameter(
            Consumer<GetRoomSkillParameterRequest.Builder> getRoomSkillParameterRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return getRoomSkillParameter(GetRoomSkillParameterRequest.builder().apply(getRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSkillGroupResponse getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSkillGroupResponse getSkillGroup(Consumer<GetSkillGroupRequest.Builder> getSkillGroupRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return getSkillGroup(GetSkillGroupRequest.builder().apply(getSkillGroupRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsResponse listSkills(ListSkillsRequest listSkillsRequest) throws SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsResponse listSkills(Consumer<ListSkillsRequest.Builder> listSkillsRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return listSkills(ListSkillsRequest.builder().apply(listSkillsRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPaginator responses = client.listSkillsIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPaginator responses = client
     *             .listSkillsIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPaginator responses = client.listSkillsIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsPaginator listSkillsIterable(ListSkillsRequest listSkillsRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for a specific resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for a specific resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return listTags(ListTagsRequest.builder().apply(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists all tags for a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPaginator responses = client.listTagsIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPaginator responses = client.listTagsIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPaginator responses = client.listTagsIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPaginator listTagsIterable(ListTagsRequest listTagsRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRoomSkillParameterResponse putRoomSkillParameter(PutRoomSkillParameterRequest putRoomSkillParameterRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default PutRoomSkillParameterResponse putRoomSkillParameter(
            Consumer<PutRoomSkillParameterRequest.Builder> putRoomSkillParameterRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return putRoomSkillParameter(PutRoomSkillParameterRequest.builder().apply(putRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default ResolveRoomResponse resolveRoom(ResolveRoomRequest resolveRoomRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default ResolveRoomResponse resolveRoom(Consumer<ResolveRoomRequest.Builder> resolveRoomRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return resolveRoom(ResolveRoomRequest.builder().apply(resolveRoomRequest).build());
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeInvitationResponse revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeInvitationResponse revokeInvitation(Consumer<RevokeInvitationRequest.Builder> revokeInvitationRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return revokeInvitation(RevokeInvitationRequest.builder().apply(revokeInvitationRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDevicesResponse searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        return searchDevices(SearchDevicesRequest.builder().apply(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPaginator responses = client.searchDevicesIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPaginator responses = client
     *             .searchDevicesIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPaginator responses = client.searchDevicesIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDevicesPaginator searchDevicesIterable(SearchDevicesRequest searchDevicesRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        return searchProfiles(SearchProfilesRequest.builder().apply(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPaginator responses = client.searchProfilesIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPaginator responses = client
     *             .searchProfilesIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPaginator responses = client.searchProfilesIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesPaginator searchProfilesIterable(SearchProfilesRequest searchProfilesRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsResponse searchRooms(SearchRoomsRequest searchRoomsRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsResponse searchRooms(Consumer<SearchRoomsRequest.Builder> searchRoomsRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchRooms(SearchRoomsRequest.builder().apply(searchRoomsRequest).build());
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPaginator responses = client.searchRoomsIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPaginator responses = client
     *             .searchRoomsIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPaginator responses = client.searchRoomsIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsPaginator searchRoomsIterable(SearchRoomsRequest searchRoomsRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsResponse searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsResponse searchSkillGroups(Consumer<SearchSkillGroupsRequest.Builder> searchSkillGroupsRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        return searchSkillGroups(SearchSkillGroupsRequest.builder().apply(searchSkillGroupsRequest).build());
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPaginator responses = client.searchSkillGroupsIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPaginator responses = client
     *             .searchSkillGroupsIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPaginator responses = client.searchSkillGroupsIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsPaginator searchSkillGroupsIterable(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersResponse searchUsers(Consumer<SearchUsersRequest.Builder> searchUsersRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        return searchUsers(SearchUsersRequest.builder().apply(searchUsersRequest).build());
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPaginator responses = client.searchUsersIterable(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPaginator responses = client
     *             .searchUsersIterable(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPaginator responses = client.searchUsersIterable(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersPaginator searchUsersIterable(SearchUsersRequest searchUsersRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 72 hours or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default SendInvitationResponse sendInvitation(SendInvitationRequest sendInvitationRequest) throws NotFoundException,
            InvalidUserStatusException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 72 hours or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default SendInvitationResponse sendInvitation(Consumer<SendInvitationRequest.Builder> sendInvitationRequest)
            throws NotFoundException, InvalidUserStatusException, SdkServiceException, SdkClientException,
            AlexaForBusinessException {
        return sendInvitation(SendInvitationRequest.builder().apply(sendInvitationRequest).build());
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings by clearing all information and settings set by
     * previous users.
     * </p>
     *
     * @param startDeviceSyncRequest
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceSyncResponse startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest) throws SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings by clearing all information and settings set by
     * previous users.
     * </p>
     *
     * @param startDeviceSyncRequest
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDeviceSyncResponse startDeviceSync(Consumer<StartDeviceSyncRequest.Builder> startDeviceSyncRequest)
            throws SdkServiceException, SdkClientException, AlexaForBusinessException {
        return startDeviceSync(StartDeviceSyncRequest.builder().apply(startDeviceSyncRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, SdkServiceException,
            SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        return tagResource(TagResourceRequest.builder().apply(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return untagResource(UntagResourceRequest.builder().apply(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws NotFoundException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDeviceResponse updateDevice(Consumer<UpdateDeviceRequest.Builder> updateDeviceRequest)
            throws NotFoundException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return updateDevice(UpdateDeviceRequest.builder().apply(updateDeviceRequest).build());
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws NotFoundException,
            NameInUseException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws NotFoundException, NameInUseException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return updateProfile(UpdateProfileRequest.builder().apply(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws NotFoundException, NameInUseException,
            SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRoomResponse updateRoom(Consumer<UpdateRoomRequest.Builder> updateRoomRequest) throws NotFoundException,
            NameInUseException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return updateRoom(UpdateRoomRequest.builder().apply(updateRoomRequest).build());
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSkillGroupResponse updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) throws NotFoundException,
            NameInUseException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSkillGroupResponse updateSkillGroup(Consumer<UpdateSkillGroupRequest.Builder> updateSkillGroupRequest)
            throws NotFoundException, NameInUseException, SdkServiceException, SdkClientException, AlexaForBusinessException {
        return updateSkillGroup(UpdateSkillGroupRequest.builder().apply(updateSkillGroupRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("a4b");
    }
}
