/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSkillGroupRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateSkillGroupRequest.Builder, CreateSkillGroupRequest> {
    private final String skillGroupName;

    private final String description;

    private final String clientRequestToken;

    private CreateSkillGroupRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupName = builder.skillGroupName;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name for the skill group.
     * </p>
     * 
     * @return The name for the skill group.
     */
    public String skillGroupName() {
        return skillGroupName;
    }

    /**
     * <p>
     * The description for the skill group.
     * </p>
     * 
     * @return The description for the skill group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A unique, user-specified identifier for this request that ensures idempotency.
     * </p>
     * 
     * @return A unique, user-specified identifier for this request that ensures idempotency.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSkillGroupRequest)) {
            return false;
        }
        CreateSkillGroupRequest other = (CreateSkillGroupRequest) obj;
        return Objects.equals(skillGroupName(), other.skillGroupName()) && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSkillGroupRequest").add("SkillGroupName", skillGroupName())
                .add("Description", description()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupName":
            return Optional.of(clazz.cast(skillGroupName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, CreateSkillGroupRequest> {
        /**
         * <p>
         * The name for the skill group.
         * </p>
         * 
         * @param skillGroupName
         *        The name for the skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupName(String skillGroupName);

        /**
         * <p>
         * The description for the skill group.
         * </p>
         * 
         * @param description
         *        The description for the skill group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, user-specified identifier for this request that ensures idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, user-specified identifier for this request that ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupName;

        private String description;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSkillGroupRequest model) {
            skillGroupName(model.skillGroupName);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getSkillGroupName() {
            return skillGroupName;
        }

        @Override
        public final Builder skillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
            return this;
        }

        public final void setSkillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateSkillGroupRequest build() {
            return new CreateSkillGroupRequest(this);
        }
    }
}
