/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSkillGroupResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateSkillGroupResponse.Builder, CreateSkillGroupResponse> {
    private final String skillGroupArn;

    private CreateSkillGroupResponse(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
    }

    /**
     * <p>
     * The ARN of the newly created skill group in the response.
     * </p>
     * 
     * @return The ARN of the newly created skill group in the response.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSkillGroupResponse)) {
            return false;
        }
        CreateSkillGroupResponse other = (CreateSkillGroupResponse) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSkillGroupResponse").add("SkillGroupArn", skillGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.of(clazz.cast(skillGroupArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, CreateSkillGroupResponse> {
        /**
         * <p>
         * The ARN of the newly created skill group in the response.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the newly created skill group in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String skillGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSkillGroupResponse model) {
            skillGroupArn(model.skillGroupArn);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        @Override
        public CreateSkillGroupResponse build() {
            return new CreateSkillGroupResponse(this);
        }
    }
}
