/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteUserRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteUserRequest.Builder, DeleteUserRequest> {
    private final String userArn;

    private final String enrollmentId;

    private DeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.enrollmentId = builder.enrollmentId;
    }

    /**
     * <p>
     * The ARN of the user to delete in the organization. Required.
     * </p>
     * 
     * @return The ARN of the user to delete in the organization. Required.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The ARN of the user's enrollment in the organization. Required.
     * </p>
     * 
     * @return The ARN of the user's enrollment in the organization. Required.
     */
    public String enrollmentId() {
        return enrollmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(enrollmentId(), other.enrollmentId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteUserRequest").add("UserArn", userArn()).add("EnrollmentId", enrollmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.of(clazz.cast(userArn()));
        case "EnrollmentId":
            return Optional.of(clazz.cast(enrollmentId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, DeleteUserRequest> {
        /**
         * <p>
         * The ARN of the user to delete in the organization. Required.
         * </p>
         * 
         * @param userArn
         *        The ARN of the user to delete in the organization. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The ARN of the user's enrollment in the organization. Required.
         * </p>
         * 
         * @param enrollmentId
         *        The ARN of the user's enrollment in the organization. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentId(String enrollmentId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String userArn;

        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            userArn(model.userArn);
            enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnrollmentId() {
            return enrollmentId;
        }

        @Override
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }
    }
}
