/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRoomSkillParameterResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetRoomSkillParameterResponse.Builder, GetRoomSkillParameterResponse> {
    private final RoomSkillParameter roomSkillParameter;

    private GetRoomSkillParameterResponse(BuilderImpl builder) {
        super(builder);
        this.roomSkillParameter = builder.roomSkillParameter;
    }

    /**
     * <p>
     * The details of the room skill parameter requested. Required.
     * </p>
     * 
     * @return The details of the room skill parameter requested. Required.
     */
    public RoomSkillParameter roomSkillParameter() {
        return roomSkillParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomSkillParameter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRoomSkillParameterResponse)) {
            return false;
        }
        GetRoomSkillParameterResponse other = (GetRoomSkillParameterResponse) obj;
        return Objects.equals(roomSkillParameter(), other.roomSkillParameter());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRoomSkillParameterResponse").add("RoomSkillParameter", roomSkillParameter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomSkillParameter":
            return Optional.of(clazz.cast(roomSkillParameter()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, GetRoomSkillParameterResponse> {
        /**
         * <p>
         * The details of the room skill parameter requested. Required.
         * </p>
         * 
         * @param roomSkillParameter
         *        The details of the room skill parameter requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomSkillParameter(RoomSkillParameter roomSkillParameter);

        /**
         * <p>
         * The details of the room skill parameter requested. Required.
         * </p>
         * This is a convenience that creates an instance of the {@link RoomSkillParameter.Builder} avoiding the need to
         * create one manually via {@link RoomSkillParameter#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoomSkillParameter.Builder#build()} is called immediately and its
         * result is passed to {@link #roomSkillParameter(RoomSkillParameter)}.
         * 
         * @param roomSkillParameter
         *        a consumer that will call methods on {@link RoomSkillParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomSkillParameter(RoomSkillParameter)
         */
        default Builder roomSkillParameter(Consumer<RoomSkillParameter.Builder> roomSkillParameter) {
            return roomSkillParameter(RoomSkillParameter.builder().apply(roomSkillParameter).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private RoomSkillParameter roomSkillParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRoomSkillParameterResponse model) {
            roomSkillParameter(model.roomSkillParameter);
        }

        public final RoomSkillParameter.Builder getRoomSkillParameter() {
            return roomSkillParameter != null ? roomSkillParameter.toBuilder() : null;
        }

        @Override
        public final Builder roomSkillParameter(RoomSkillParameter roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter;
            return this;
        }

        public final void setRoomSkillParameter(RoomSkillParameter.BuilderImpl roomSkillParameter) {
            this.roomSkillParameter = roomSkillParameter != null ? roomSkillParameter.build() : null;
        }

        @Override
        public GetRoomSkillParameterResponse build() {
            return new GetRoomSkillParameterResponse(this);
        }
    }
}
