/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListSkillsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListSkillsResponse.Builder, ListSkillsResponse> {
    private final List<SkillSummary> skillSummaries;

    private final String nextToken;

    private ListSkillsResponse(BuilderImpl builder) {
        super(builder);
        this.skillSummaries = builder.skillSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of enabled skills requested. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of enabled skills requested. Required.
     */
    public List<SkillSummary> skillSummaries() {
        return skillSummaries;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsResponse)) {
            return false;
        }
        ListSkillsResponse other = (ListSkillsResponse) obj;
        return Objects.equals(skillSummaries(), other.skillSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListSkillsResponse").add("SkillSummaries", skillSummaries()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillSummaries":
            return Optional.of(clazz.cast(skillSummaries()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, ListSkillsResponse> {
        /**
         * <p>
         * The list of enabled skills requested. Required.
         * </p>
         * 
         * @param skillSummaries
         *        The list of enabled skills requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillSummaries(Collection<SkillSummary> skillSummaries);

        /**
         * <p>
         * The list of enabled skills requested. Required.
         * </p>
         * 
         * @param skillSummaries
         *        The list of enabled skills requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillSummaries(SkillSummary... skillSummaries);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<SkillSummary> skillSummaries;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsResponse model) {
            skillSummaries(model.skillSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<SkillSummary.Builder> getSkillSummaries() {
            return skillSummaries != null ? skillSummaries.stream().map(SkillSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder skillSummaries(Collection<SkillSummary> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copy(skillSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillSummaries(SkillSummary... skillSummaries) {
            skillSummaries(Arrays.asList(skillSummaries));
            return this;
        }

        public final void setSkillSummaries(Collection<SkillSummary.BuilderImpl> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copyFromBuilder(skillSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsResponse build() {
            return new ListSkillsResponse(this);
        }
    }
}
