/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ResolveRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ResolveRoomRequest.Builder, ResolveRoomRequest> {
    private final String userId;

    private final String skillId;

    private ResolveRoomRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.skillId = builder.skillId;
    }

    /**
     * <p>
     * The ARN of the user. Required.
     * </p>
     * 
     * @return The ARN of the user. Required.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The ARN of the skill that was requested. Required.
     * </p>
     * 
     * @return The ARN of the skill that was requested. Required.
     */
    public String skillId() {
        return skillId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomRequest)) {
            return false;
        }
        ResolveRoomRequest other = (ResolveRoomRequest) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(skillId(), other.skillId());
    }

    @Override
    public String toString() {
        return ToString.builder("ResolveRoomRequest").add("UserId", userId()).add("SkillId", skillId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        case "SkillId":
            return Optional.of(clazz.cast(skillId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, ResolveRoomRequest> {
        /**
         * <p>
         * The ARN of the user. Required.
         * </p>
         * 
         * @param userId
         *        The ARN of the user. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ARN of the skill that was requested. Required.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill that was requested. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String userId;

        private String skillId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomRequest model) {
            userId(model.userId);
            skillId(model.skillId);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResolveRoomRequest build() {
            return new ResolveRoomRequest(this);
        }
    }
}
