/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchRoomsResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<SearchRoomsResponse.Builder, SearchRoomsResponse> {
    private final List<RoomData> rooms;

    private final String nextToken;

    private final Integer totalCount;

    private SearchRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    /**
     * <p>
     * The rooms that meet the specified set of filter criteria, in sort order.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The rooms that meet the specified set of filter criteria, in sort order.
     */
    public List<RoomData> rooms() {
        return rooms;
    }

    /**
     * <p>
     * The token returned to indicate that there is more data available.
     * </p>
     * 
     * @return The token returned to indicate that there is more data available.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of rooms returned.
     * </p>
     * 
     * @return The total number of rooms returned.
     */
    public Integer totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rooms());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRoomsResponse)) {
            return false;
        }
        SearchRoomsResponse other = (SearchRoomsResponse) obj;
        return Objects.equals(rooms(), other.rooms()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(totalCount(), other.totalCount());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchRoomsResponse").add("Rooms", rooms()).add("NextToken", nextToken())
                .add("TotalCount", totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rooms":
            return Optional.of(clazz.cast(rooms()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.of(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, SearchRoomsResponse> {
        /**
         * <p>
         * The rooms that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param rooms
         *        The rooms that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(Collection<RoomData> rooms);

        /**
         * <p>
         * The rooms that meet the specified set of filter criteria, in sort order.
         * </p>
         * 
         * @param rooms
         *        The rooms that meet the specified set of filter criteria, in sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(RoomData... rooms);

        /**
         * <p>
         * The token returned to indicate that there is more data available.
         * </p>
         * 
         * @param nextToken
         *        The token returned to indicate that there is more data available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of rooms returned.
         * </p>
         * 
         * @param totalCount
         *        The total number of rooms returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<RoomData> rooms;

        private String nextToken;

        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRoomsResponse model) {
            rooms(model.rooms);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
        }

        public final Collection<RoomData.Builder> getRooms() {
            return rooms != null ? rooms.stream().map(RoomData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rooms(Collection<RoomData> rooms) {
            this.rooms = RoomDataListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomData... rooms) {
            rooms(Arrays.asList(rooms));
            return this;
        }

        public final void setRooms(Collection<RoomData.BuilderImpl> rooms) {
            this.rooms = RoomDataListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchRoomsResponse build() {
            return new SearchRoomsResponse(this);
        }
    }
}
