/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendInvitationRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<SendInvitationRequest.Builder, SendInvitationRequest> {
    private final String userArn;

    private SendInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
    }

    /**
     * <p>
     * The ARN of the user to whom to send an invitation. Required.
     * </p>
     * 
     * @return The ARN of the user to whom to send an invitation. Required.
     */
    public String userArn() {
        return userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendInvitationRequest)) {
            return false;
        }
        SendInvitationRequest other = (SendInvitationRequest) obj;
        return Objects.equals(userArn(), other.userArn());
    }

    @Override
    public String toString() {
        return ToString.builder("SendInvitationRequest").add("UserArn", userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.of(clazz.cast(userArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, SendInvitationRequest> {
        /**
         * <p>
         * The ARN of the user to whom to send an invitation. Required.
         * </p>
         * 
         * @param userArn
         *        The ARN of the user to whom to send an invitation. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SendInvitationRequest model) {
            userArn(model.userArn);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendInvitationRequest build() {
            return new SendInvitationRequest(this);
        }
    }
}
