/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.SkillSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of skills.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SkillSummary implements StructuredPojo, ToCopyableBuilder<SkillSummary.Builder, SkillSummary> {
    private final String skillId;

    private final String skillName;

    private final Boolean supportsLinking;

    private SkillSummary(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.supportsLinking = builder.supportsLinking;
    }

    /**
     * <p>
     * The ARN of the skill summary.
     * </p>
     * 
     * @return The ARN of the skill summary.
     */
    public String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The name of the skill.
     * </p>
     * 
     * @return The name of the skill.
     */
    public String skillName() {
        return skillName;
    }

    /**
     * <p>
     * Linking support for a skill.
     * </p>
     * 
     * @return Linking support for a skill.
     */
    public Boolean supportsLinking() {
        return supportsLinking;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(skillName());
        hashCode = 31 * hashCode + Objects.hashCode(supportsLinking());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillSummary)) {
            return false;
        }
        SkillSummary other = (SkillSummary) obj;
        return Objects.equals(skillId(), other.skillId()) && Objects.equals(skillName(), other.skillName())
                && Objects.equals(supportsLinking(), other.supportsLinking());
    }

    @Override
    public String toString() {
        return ToString.builder("SkillSummary").add("SkillId", skillId()).add("SkillName", skillName())
                .add("SupportsLinking", supportsLinking()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillId":
            return Optional.of(clazz.cast(skillId()));
        case "SkillName":
            return Optional.of(clazz.cast(skillName()));
        case "SupportsLinking":
            return Optional.of(clazz.cast(supportsLinking()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SkillSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SkillSummary> {
        /**
         * <p>
         * The ARN of the skill summary.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The name of the skill.
         * </p>
         * 
         * @param skillName
         *        The name of the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillName(String skillName);

        /**
         * <p>
         * Linking support for a skill.
         * </p>
         * 
         * @param supportsLinking
         *        Linking support for a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsLinking(Boolean supportsLinking);
    }

    static final class BuilderImpl implements Builder {
        private String skillId;

        private String skillName;

        private Boolean supportsLinking;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillSummary model) {
            skillId(model.skillId);
            skillName(model.skillName);
            supportsLinking(model.supportsLinking);
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getSkillName() {
            return skillName;
        }

        @Override
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        public final Boolean getSupportsLinking() {
            return supportsLinking;
        }

        @Override
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        @Override
        public SkillSummary build() {
            return new SkillSummary(this);
        }
    }
}
