/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class StartDeviceSyncRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<StartDeviceSyncRequest.Builder, StartDeviceSyncRequest> {
    private final String roomArn;

    private final String deviceArn;

    private final List<String> features;

    private StartDeviceSyncRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.deviceArn = builder.deviceArn;
        this.features = builder.features;
    }

    /**
     * <p>
     * The ARN of the room with which the device to sync is associated. Required.
     * </p>
     * 
     * @return The ARN of the room with which the device to sync is associated. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The ARN of the device to sync. Required.
     * </p>
     * 
     * @return The ARN of the device to sync. Required.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * Request structure to start the device sync. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Request structure to start the device sync. Required.
     */
    public List<Feature> features() {
        return TypeConverter.convert(features, Feature::fromValue);
    }

    /**
     * <p>
     * Request structure to start the device sync. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Request structure to start the device sync. Required.
     */
    public List<String> featuresStrings() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(featuresStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceSyncRequest)) {
            return false;
        }
        StartDeviceSyncRequest other = (StartDeviceSyncRequest) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(featuresStrings(), other.featuresStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("StartDeviceSyncRequest").add("RoomArn", roomArn()).add("DeviceArn", deviceArn())
                .add("Features", featuresStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.of(clazz.cast(roomArn()));
        case "DeviceArn":
            return Optional.of(clazz.cast(deviceArn()));
        case "Features":
            return Optional.of(clazz.cast(featuresStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, StartDeviceSyncRequest> {
        /**
         * <p>
         * The ARN of the room with which the device to sync is associated. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room with which the device to sync is associated. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The ARN of the device to sync. Required.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<String> features);

        /**
         * <p>
         * Request structure to start the device sync. Required.
         * </p>
         * 
         * @param features
         *        Request structure to start the device sync. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(String... features);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomArn;

        private String deviceArn;

        private List<String> features;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceSyncRequest model) {
            roomArn(model.roomArn);
            deviceArn(model.deviceArn);
            features(model.features);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getFeatures() {
            return features;
        }

        @Override
        public final Builder features(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(String... features) {
            features(Arrays.asList(features));
            return this;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceSyncRequest build() {
            return new StartDeviceSyncRequest(this);
        }
    }
}
