/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateRoomRequest.Builder, UpdateRoomRequest> {
    private final String roomArn;

    private final String roomName;

    private final String description;

    private final String providerCalendarId;

    private final String profileArn;

    private UpdateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The ARN of the room to update.
     * </p>
     * 
     * @return The ARN of the room to update.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The updated name for the room.
     * </p>
     * 
     * @return The updated name for the room.
     */
    public String roomName() {
        return roomName;
    }

    /**
     * <p>
     * The updated description for the room.
     * </p>
     * 
     * @return The updated description for the room.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The updated provider calendar ARN for the room.
     * </p>
     * 
     * @return The updated provider calendar ARN for the room.
     */
    public String providerCalendarId() {
        return providerCalendarId;
    }

    /**
     * <p>
     * The updated profile ARN for the room.
     * </p>
     * 
     * @return The updated profile ARN for the room.
     */
    public String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoomRequest)) {
            return false;
        }
        UpdateRoomRequest other = (UpdateRoomRequest) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(roomName(), other.roomName())
                && Objects.equals(description(), other.description())
                && Objects.equals(providerCalendarId(), other.providerCalendarId())
                && Objects.equals(profileArn(), other.profileArn());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateRoomRequest").add("RoomArn", roomArn()).add("RoomName", roomName())
                .add("Description", description()).add("ProviderCalendarId", providerCalendarId())
                .add("ProfileArn", profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.of(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.of(clazz.cast(roomName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ProviderCalendarId":
            return Optional.of(clazz.cast(providerCalendarId()));
        case "ProfileArn":
            return Optional.of(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, UpdateRoomRequest> {
        /**
         * <p>
         * The ARN of the room to update.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The updated name for the room.
         * </p>
         * 
         * @param roomName
         *        The updated name for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * The updated description for the room.
         * </p>
         * 
         * @param description
         *        The updated description for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated provider calendar ARN for the room.
         * </p>
         * 
         * @param providerCalendarId
         *        The updated provider calendar ARN for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerCalendarId(String providerCalendarId);

        /**
         * <p>
         * The updated profile ARN for the room.
         * </p>
         * 
         * @param profileArn
         *        The updated profile ARN for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomArn;

        private String roomName;

        private String description;

        private String providerCalendarId;

        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoomRequest model) {
            roomArn(model.roomArn);
            roomName(model.roomName);
            description(model.description);
            providerCalendarId(model.providerCalendarId);
            profileArn(model.profileArn);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderCalendarId() {
            return providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoomRequest build() {
            return new UpdateRoomRequest(this);
        }
    }
}
