/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;

import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.alexaforbusiness.model.*;
import software.amazon.awssdk.services.alexaforbusiness.transform.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * GetRoomSkillParameterRequest Marshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class GetRoomSkillParameterRequestMarshaller implements
        Marshaller<Request<GetRoomSkillParameterRequest>, GetRoomSkillParameterRequest> {

    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON)
            .requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true)
            .operationIdentifier("AlexaForBusiness.GetRoomSkillParameter").serviceName("AlexaForBusinessClient").build();

    private final software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory protocolFactory;

    public GetRoomSkillParameterRequestMarshaller(software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetRoomSkillParameterRequest> marshall(GetRoomSkillParameterRequest getRoomSkillParameterRequest) {

        if (getRoomSkillParameterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            final ProtocolRequestMarshaller<GetRoomSkillParameterRequest> protocolMarshaller = protocolFactory
                    .createProtocolMarshaller(SDK_OPERATION_BINDING, getRoomSkillParameterRequest);

            protocolMarshaller.startMarshalling();
            GetRoomSkillParameterRequestModelMarshaller.getInstance().marshall(getRoomSkillParameterRequest, protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
