/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.alexaforbusiness.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * TagResourceResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TagResourceResponseUnmarshaller implements Unmarshaller<TagResourceResponse, JsonUnmarshallerContext> {

    public TagResourceResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        TagResourceResponse.Builder tagResourceResponseBuilder = TagResourceResponse.builder();

        return tagResourceResponseBuilder.build();
    }

    private static final TagResourceResponseUnmarshaller INSTANCE = new TagResourceResponseUnmarshaller();

    public static TagResourceResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
