/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateSkillGroupWithRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, AssociateSkillGroupWithRoomRequest> {
    private final String skillGroupArn;
    private final String roomArn;

    private AssociateSkillGroupWithRoomRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.roomArn = builder.roomArn;
    }

    public String skillGroupArn() {
        return this.skillGroupArn;
    }

    public String roomArn() {
        return this.roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSkillGroupWithRoomRequest)) {
            return false;
        }
        AssociateSkillGroupWithRoomRequest other = (AssociateSkillGroupWithRoomRequest)((Object)obj);
        return Objects.equals(this.skillGroupArn(), other.skillGroupArn()) && Objects.equals(this.roomArn(), other.roomArn());
    }

    public String toString() {
        return ToString.builder((String)"AssociateSkillGroupWithRoomRequest").add("SkillGroupArn", (Object)this.skillGroupArn()).add("RoomArn", (Object)this.roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillGroupArn": {
                return Optional.of(clazz.cast(this.skillGroupArn()));
            }
            case "RoomArn": {
                return Optional.of(clazz.cast(this.roomArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String skillGroupArn;
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSkillGroupWithRoomRequest model) {
            this.skillGroupArn(model.skillGroupArn);
            this.roomArn(model.roomArn);
        }

        public final String getSkillGroupArn() {
            return this.skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssociateSkillGroupWithRoomRequest build() {
            return new AssociateSkillGroupWithRoomRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, AssociateSkillGroupWithRoomRequest> {
        public Builder skillGroupArn(String var1);

        public Builder roomArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

