/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.WakeWord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProfileRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private final String profileName;
    private final String timezone;
    private final String address;
    private final String distanceUnit;
    private final String temperatureUnit;
    private final String wakeWord;
    private final String clientRequestToken;
    private final Boolean setupModeDisabled;
    private final Integer maxVolumeLimit;
    private final Boolean pstnEnabled;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileName = builder.profileName;
        this.timezone = builder.timezone;
        this.address = builder.address;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.clientRequestToken = builder.clientRequestToken;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
    }

    public String profileName() {
        return this.profileName;
    }

    public String timezone() {
        return this.timezone;
    }

    public String address() {
        return this.address;
    }

    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public String distanceUnitString() {
        return this.distanceUnit;
    }

    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(this.temperatureUnit);
    }

    public String temperatureUnitString() {
        return this.temperatureUnit;
    }

    public WakeWord wakeWord() {
        return WakeWord.fromValue(this.wakeWord);
    }

    public String wakeWordString() {
        return this.wakeWord;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public Boolean setupModeDisabled() {
        return this.setupModeDisabled;
    }

    public Integer maxVolumeLimit() {
        return this.maxVolumeLimit;
    }

    public Boolean pstnEnabled() {
        return this.pstnEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperatureUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeWordString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.pstnEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.distanceUnitString(), other.distanceUnitString()) && Objects.equals(this.temperatureUnitString(), other.temperatureUnitString()) && Objects.equals(this.wakeWordString(), other.wakeWordString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.setupModeDisabled(), other.setupModeDisabled()) && Objects.equals(this.maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(this.pstnEnabled(), other.pstnEnabled());
    }

    public String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("ProfileName", (Object)this.profileName()).add("Timezone", (Object)this.timezone()).add("Address", (Object)this.address()).add("DistanceUnit", (Object)this.distanceUnitString()).add("TemperatureUnit", (Object)this.temperatureUnitString()).add("WakeWord", (Object)this.wakeWordString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("SetupModeDisabled", (Object)this.setupModeDisabled()).add("MaxVolumeLimit", (Object)this.maxVolumeLimit()).add("PSTNEnabled", (Object)this.pstnEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileName": {
                return Optional.of(clazz.cast(this.profileName()));
            }
            case "Timezone": {
                return Optional.of(clazz.cast(this.timezone()));
            }
            case "Address": {
                return Optional.of(clazz.cast(this.address()));
            }
            case "DistanceUnit": {
                return Optional.of(clazz.cast(this.distanceUnitString()));
            }
            case "TemperatureUnit": {
                return Optional.of(clazz.cast(this.temperatureUnitString()));
            }
            case "WakeWord": {
                return Optional.of(clazz.cast(this.wakeWordString()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "SetupModeDisabled": {
                return Optional.of(clazz.cast(this.setupModeDisabled()));
            }
            case "MaxVolumeLimit": {
                return Optional.of(clazz.cast(this.maxVolumeLimit()));
            }
            case "PSTNEnabled": {
                return Optional.of(clazz.cast(this.pstnEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String profileName;
        private String timezone;
        private String address;
        private String distanceUnit;
        private String temperatureUnit;
        private String wakeWord;
        private String clientRequestToken;
        private Boolean setupModeDisabled;
        private Integer maxVolumeLimit;
        private Boolean pstnEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            this.profileName(model.profileName);
            this.timezone(model.timezone);
            this.address(model.address);
            this.distanceUnit(model.distanceUnit);
            this.temperatureUnit(model.temperatureUnit);
            this.wakeWord(model.wakeWord);
            this.clientRequestToken(model.clientRequestToken);
            this.setupModeDisabled(model.setupModeDisabled);
            this.maxVolumeLimit(model.maxVolumeLimit);
            this.pstnEnabled(model.pstnEnabled);
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getDistanceUnit() {
            return this.distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnit() {
            return this.temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWord() {
            return this.wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Boolean getSetupModeDisabled() {
            return this.setupModeDisabled;
        }

        @Override
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        public final Integer getMaxVolumeLimit() {
            return this.maxVolumeLimit;
        }

        @Override
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        public final Boolean getPSTNEnabled() {
            return this.pstnEnabled;
        }

        @Override
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final void setPSTNEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder profileName(String var1);

        public Builder timezone(String var1);

        public Builder address(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder temperatureUnit(String var1);

        public Builder temperatureUnit(TemperatureUnit var1);

        public Builder wakeWord(String var1);

        public Builder wakeWord(WakeWord var1);

        public Builder clientRequestToken(String var1);

        public Builder setupModeDisabled(Boolean var1);

        public Builder maxVolumeLimit(Integer var1);

        public Builder pstnEnabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

