/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.Tag;
import software.amazon.awssdk.services.alexaforbusiness.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateRoomRequest> {
    private final String roomName;
    private final String description;
    private final String profileArn;
    private final String providerCalendarId;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.profileArn = builder.profileArn;
        this.providerCalendarId = builder.providerCalendarId;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public String roomName() {
        return this.roomName;
    }

    public String description() {
        return this.description;
    }

    public String profileArn() {
        return this.profileArn;
    }

    public String providerCalendarId() {
        return this.providerCalendarId;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomRequest)) {
            return false;
        }
        CreateRoomRequest other = (CreateRoomRequest)((Object)obj);
        return Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.providerCalendarId(), other.providerCalendarId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateRoomRequest").add("RoomName", (Object)this.roomName()).add("Description", (Object)this.description()).add("ProfileArn", (Object)this.profileArn()).add("ProviderCalendarId", (Object)this.providerCalendarId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomName": {
                return Optional.of(clazz.cast(this.roomName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ProfileArn": {
                return Optional.of(clazz.cast(this.profileArn()));
            }
            case "ProviderCalendarId": {
                return Optional.of(clazz.cast(this.providerCalendarId()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomName;
        private String description;
        private String profileArn;
        private String providerCalendarId;
        private String clientRequestToken;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomRequest model) {
            this.roomName(model.roomName);
            this.description(model.description);
            this.profileArn(model.profileArn);
            this.providerCalendarId(model.providerCalendarId);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProviderCalendarId() {
            return this.providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRoomRequest build() {
            return new CreateRoomRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, CreateRoomRequest> {
        public Builder roomName(String var1);

        public Builder description(String var1);

        public Builder profileArn(String var1);

        public Builder providerCalendarId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

