/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.Tag;
import software.amazon.awssdk.services.alexaforbusiness.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateUserRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private final String userId;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public String userId() {
        return this.userId;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String email() {
        return this.email;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateUserRequest").add("UserId", (Object)this.userId()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("Email", (Object)this.email()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "FirstName": {
                return Optional.of(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.of(clazz.cast(this.lastName()));
            }
            case "Email": {
                return Optional.of(clazz.cast(this.email()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String userId;
        private String firstName;
        private String lastName;
        private String email;
        private String clientRequestToken;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            this.userId(model.userId);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.email(model.email);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return this.lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder userId(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder email(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

