/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteUserRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, DeleteUserRequest> {
    private final String userArn;
    private final String enrollmentId;

    private DeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.enrollmentId = builder.enrollmentId;
    }

    public String userArn() {
        return this.userArn;
    }

    public String enrollmentId() {
        return this.enrollmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enrollmentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest)((Object)obj);
        return Objects.equals(this.userArn(), other.userArn()) && Objects.equals(this.enrollmentId(), other.enrollmentId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteUserRequest").add("UserArn", (Object)this.userArn()).add("EnrollmentId", (Object)this.enrollmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserArn": {
                return Optional.of(clazz.cast(this.userArn()));
            }
            case "EnrollmentId": {
                return Optional.of(clazz.cast(this.enrollmentId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String userArn;
        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            this.userArn(model.userArn);
            this.enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return this.userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnrollmentId() {
            return this.enrollmentId;
        }

        @Override
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, DeleteUserRequest> {
        public Builder userArn(String var1);

        public Builder enrollmentId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

