/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListSkillsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListSkillsResponse> {
    private final List<SkillSummary> skillSummaries;
    private final String nextToken;

    private ListSkillsResponse(BuilderImpl builder) {
        super(builder);
        this.skillSummaries = builder.skillSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<SkillSummary> skillSummaries() {
        return this.skillSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsResponse)) {
            return false;
        }
        ListSkillsResponse other = (ListSkillsResponse)((Object)obj);
        return Objects.equals(this.skillSummaries(), other.skillSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSkillsResponse").add("SkillSummaries", this.skillSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillSummaries": {
                return Optional.of(clazz.cast(this.skillSummaries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<SkillSummary> skillSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsResponse model) {
            this.skillSummaries(model.skillSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SkillSummary.Builder> getSkillSummaries() {
            return this.skillSummaries != null ? (Collection)this.skillSummaries.stream().map(SkillSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder skillSummaries(Collection<SkillSummary> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copy(skillSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skillSummaries(SkillSummary ... skillSummaries) {
            this.skillSummaries(Arrays.asList(skillSummaries));
            return this;
        }

        public final void setSkillSummaries(Collection<SkillSummary.BuilderImpl> skillSummaries) {
            this.skillSummaries = SkillSummaryListCopier.copyFromBuilder(skillSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsResponse build() {
            return new ListSkillsResponse(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    CopyableBuilder<Builder, ListSkillsResponse> {
        public Builder skillSummaries(Collection<SkillSummary> var1);

        public Builder skillSummaries(SkillSummary ... var1);

        public Builder nextToken(String var1);
    }
}

