/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResolveRoomRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, ResolveRoomRequest> {
    private final String userId;
    private final String skillId;

    private ResolveRoomRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.skillId = builder.skillId;
    }

    public String userId() {
        return this.userId;
    }

    public String skillId() {
        return this.skillId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveRoomRequest)) {
            return false;
        }
        ResolveRoomRequest other = (ResolveRoomRequest)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.skillId(), other.skillId());
    }

    public String toString() {
        return ToString.builder((String)"ResolveRoomRequest").add("UserId", (Object)this.userId()).add("SkillId", (Object)this.skillId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
            case "SkillId": {
                return Optional.of(clazz.cast(this.skillId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String userId;
        private String skillId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveRoomRequest model) {
            this.userId(model.userId);
            this.skillId(model.skillId);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getSkillId() {
            return this.skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResolveRoomRequest build() {
            return new ResolveRoomRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, ResolveRoomRequest> {
        public Builder userId(String var1);

        public Builder skillId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

