/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomData;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchRoomsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchRoomsResponse> {
    private final List<RoomData> rooms;
    private final String nextToken;
    private final Integer totalCount;

    private SearchRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public List<RoomData> rooms() {
        return this.rooms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rooms());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRoomsResponse)) {
            return false;
        }
        SearchRoomsResponse other = (SearchRoomsResponse)((Object)obj);
        return Objects.equals(this.rooms(), other.rooms()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchRoomsResponse").add("Rooms", this.rooms()).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rooms": {
                return Optional.of(clazz.cast(this.rooms()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.of(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<RoomData> rooms;
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRoomsResponse model) {
            this.rooms(model.rooms);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<RoomData.Builder> getRooms() {
            return this.rooms != null ? (Collection)this.rooms.stream().map(RoomData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rooms(Collection<RoomData> rooms) {
            this.rooms = RoomDataListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomData ... rooms) {
            this.rooms(Arrays.asList(rooms));
            return this;
        }

        public final void setRooms(Collection<RoomData.BuilderImpl> rooms) {
            this.rooms = RoomDataListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchRoomsResponse build() {
            return new SearchRoomsResponse(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    CopyableBuilder<Builder, SearchRoomsResponse> {
        public Builder rooms(Collection<RoomData> var1);

        public Builder rooms(RoomData ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

