/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.SkillGroupDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SkillGroupData
implements StructuredPojo,
ToCopyableBuilder<Builder, SkillGroupData> {
    private final String skillGroupArn;
    private final String skillGroupName;
    private final String description;

    private SkillGroupData(BuilderImpl builder) {
        this.skillGroupArn = builder.skillGroupArn;
        this.skillGroupName = builder.skillGroupName;
        this.description = builder.description;
    }

    public String skillGroupArn() {
        return this.skillGroupArn;
    }

    public String skillGroupName() {
        return this.skillGroupName;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.skillGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillGroupData)) {
            return false;
        }
        SkillGroupData other = (SkillGroupData)obj;
        return Objects.equals(this.skillGroupArn(), other.skillGroupArn()) && Objects.equals(this.skillGroupName(), other.skillGroupName()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"SkillGroupData").add("SkillGroupArn", (Object)this.skillGroupArn()).add("SkillGroupName", (Object)this.skillGroupName()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkillGroupArn": {
                return Optional.of(clazz.cast(this.skillGroupArn()));
            }
            case "SkillGroupName": {
                return Optional.of(clazz.cast(this.skillGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SkillGroupDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String skillGroupArn;
        private String skillGroupName;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillGroupData model) {
            this.skillGroupArn(model.skillGroupArn);
            this.skillGroupName(model.skillGroupName);
            this.description(model.description);
        }

        public final String getSkillGroupArn() {
            return this.skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getSkillGroupName() {
            return this.skillGroupName;
        }

        @Override
        public final Builder skillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
            return this;
        }

        public final void setSkillGroupName(String skillGroupName) {
            this.skillGroupName = skillGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public SkillGroupData build() {
            return new SkillGroupData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SkillGroupData> {
        public Builder skillGroupArn(String var1);

        public Builder skillGroupName(String var1);

        public Builder description(String var1);
    }
}

