/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.model.SortValue;
import software.amazon.awssdk.services.alexaforbusiness.transform.SortMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Sort
implements StructuredPojo,
ToCopyableBuilder<Builder, Sort> {
    private final String key;
    private final String value;

    private Sort(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    public String key() {
        return this.key;
    }

    public SortValue value() {
        return SortValue.fromValue(this.value);
    }

    public String valueString() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.valueString(), other.valueString());
    }

    public String toString() {
        return ToString.builder((String)"Sort").add("Key", (Object)this.key()).add("Value", (Object)this.valueString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.valueString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SortMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            this.key(model.key);
            this.value(model.value);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(SortValue value) {
            this.value(value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Sort build() {
            return new Sort(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Sort> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder value(SortValue var1);
    }
}

