/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.Feature;
import software.amazon.awssdk.services.alexaforbusiness.model.FeaturesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartDeviceSyncRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, StartDeviceSyncRequest> {
    private final String roomArn;
    private final String deviceArn;
    private final List<String> features;

    private StartDeviceSyncRequest(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
        this.deviceArn = builder.deviceArn;
        this.features = builder.features;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public List<Feature> features() {
        return TypeConverter.convert(this.features, Feature::fromValue);
    }

    public List<String> featuresStrings() {
        return this.features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuresStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceSyncRequest)) {
            return false;
        }
        StartDeviceSyncRequest other = (StartDeviceSyncRequest)((Object)obj);
        return Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.featuresStrings(), other.featuresStrings());
    }

    public String toString() {
        return ToString.builder((String)"StartDeviceSyncRequest").add("RoomArn", (Object)this.roomArn()).add("DeviceArn", (Object)this.deviceArn()).add("Features", this.featuresStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoomArn": {
                return Optional.of(clazz.cast(this.roomArn()));
            }
            case "DeviceArn": {
                return Optional.of(clazz.cast(this.deviceArn()));
            }
            case "Features": {
                return Optional.of(clazz.cast(this.featuresStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String roomArn;
        private String deviceArn;
        private List<String> features;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceSyncRequest model) {
            this.roomArn(model.roomArn);
            this.deviceArn(model.deviceArn);
            this.features(model.features);
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Collection<String> getFeatures() {
            return this.features;
        }

        @Override
        public final Builder features(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(String ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = FeaturesCopier.copy(features);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceSyncRequest build() {
            return new StartDeviceSyncRequest(this);
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    CopyableBuilder<Builder, StartDeviceSyncRequest> {
        public Builder roomArn(String var1);

        public Builder deviceArn(String var1);

        public Builder features(Collection<String> var1);

        public Builder features(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

