/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;

public final class ListSkillsPaginator
implements SdkIterable<ListSkillsResponse> {
    private final AlexaForBusinessClient client;
    private final ListSkillsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSkillsPaginator(AlexaForBusinessClient client, ListSkillsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSkillsResponseFetcher();
    }

    public Iterator<ListSkillsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListSkillsResponseFetcher
    implements NextPageFetcher<ListSkillsResponse> {
        private ListSkillsResponseFetcher() {
        }

        public boolean hasNextPage(ListSkillsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSkillsResponse nextPage(ListSkillsResponse previousPage) {
            if (previousPage == null) {
                return ListSkillsPaginator.this.client.listSkills(ListSkillsPaginator.this.firstRequest);
            }
            return ListSkillsPaginator.this.client.listSkills((ListSkillsRequest)((Object)ListSkillsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

