/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;

public final class SearchDevicesPaginator
implements SdkIterable<SearchDevicesResponse> {
    private final AlexaForBusinessClient client;
    private final SearchDevicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchDevicesPaginator(AlexaForBusinessClient client, SearchDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchDevicesResponseFetcher();
    }

    public Iterator<SearchDevicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchDevicesResponseFetcher
    implements NextPageFetcher<SearchDevicesResponse> {
        private SearchDevicesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDevicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public SearchDevicesResponse nextPage(SearchDevicesResponse previousPage) {
            if (previousPage == null) {
                return SearchDevicesPaginator.this.client.searchDevices(SearchDevicesPaginator.this.firstRequest);
            }
            return SearchDevicesPaginator.this.client.searchDevices((SearchDevicesRequest)((Object)SearchDevicesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

