/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;

public final class SearchProfilesPaginator
implements SdkIterable<SearchProfilesResponse> {
    private final AlexaForBusinessClient client;
    private final SearchProfilesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchProfilesPaginator(AlexaForBusinessClient client, SearchProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchProfilesResponseFetcher();
    }

    public Iterator<SearchProfilesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchProfilesResponseFetcher
    implements NextPageFetcher<SearchProfilesResponse> {
        private SearchProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchProfilesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public SearchProfilesResponse nextPage(SearchProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchProfilesPaginator.this.client.searchProfiles(SearchProfilesPaginator.this.firstRequest);
            }
            return SearchProfilesPaginator.this.client.searchProfiles((SearchProfilesRequest)((Object)SearchProfilesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

