/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;

public final class SearchRoomsPaginator
implements SdkIterable<SearchRoomsResponse> {
    private final AlexaForBusinessClient client;
    private final SearchRoomsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchRoomsPaginator(AlexaForBusinessClient client, SearchRoomsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchRoomsResponseFetcher();
    }

    public Iterator<SearchRoomsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchRoomsResponseFetcher
    implements NextPageFetcher<SearchRoomsResponse> {
        private SearchRoomsResponseFetcher() {
        }

        public boolean hasNextPage(SearchRoomsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public SearchRoomsResponse nextPage(SearchRoomsResponse previousPage) {
            if (previousPage == null) {
                return SearchRoomsPaginator.this.client.searchRooms(SearchRoomsPaginator.this.firstRequest);
            }
            return SearchRoomsPaginator.this.client.searchRooms((SearchRoomsRequest)((Object)SearchRoomsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

