/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;

public final class SearchSkillGroupsPaginator
implements SdkIterable<SearchSkillGroupsResponse> {
    private final AlexaForBusinessClient client;
    private final SearchSkillGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchSkillGroupsPaginator(AlexaForBusinessClient client, SearchSkillGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchSkillGroupsResponseFetcher();
    }

    public Iterator<SearchSkillGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchSkillGroupsResponseFetcher
    implements NextPageFetcher<SearchSkillGroupsResponse> {
        private SearchSkillGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSkillGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public SearchSkillGroupsResponse nextPage(SearchSkillGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchSkillGroupsPaginator.this.client.searchSkillGroups(SearchSkillGroupsPaginator.this.firstRequest);
            }
            return SearchSkillGroupsPaginator.this.client.searchSkillGroups((SearchSkillGroupsRequest)((Object)SearchSkillGroupsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

