/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;

public final class SearchUsersPaginator
implements SdkIterable<SearchUsersResponse> {
    private final AlexaForBusinessClient client;
    private final SearchUsersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public SearchUsersPaginator(AlexaForBusinessClient client, SearchUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchUsersResponseFetcher();
    }

    public Iterator<SearchUsersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class SearchUsersResponseFetcher
    implements NextPageFetcher<SearchUsersResponse> {
        private SearchUsersResponseFetcher() {
        }

        public boolean hasNextPage(SearchUsersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public SearchUsersResponse nextPage(SearchUsersResponse previousPage) {
            if (previousPage == null) {
                return SearchUsersPaginator.this.client.searchUsers(SearchUsersPaginator.this.firstRequest);
            }
            return SearchUsersPaginator.this.client.searchUsers((SearchUsersRequest)((Object)SearchUsersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

