/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;

@SdkInternalApi
public class CreateProfileRequestModelMarshaller {
    private static final MarshallingInfo<String> PROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileName").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final MarshallingInfo<String> DISTANCEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DistanceUnit").build();
    private static final MarshallingInfo<String> TEMPERATUREUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemperatureUnit").build();
    private static final MarshallingInfo<String> WAKEWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WakeWord").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<Boolean> SETUPMODEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SetupModeDisabled").build();
    private static final MarshallingInfo<Integer> MAXVOLUMELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxVolumeLimit").build();
    private static final MarshallingInfo<Boolean> PSTNENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PSTNEnabled").build();
    private static final CreateProfileRequestModelMarshaller INSTANCE = new CreateProfileRequestModelMarshaller();

    public static CreateProfileRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateProfileRequest createProfileRequest, ProtocolMarshaller protocolMarshaller) {
        if (createProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createProfileRequest.profileName(), PROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.timezone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.distanceUnitString(), DISTANCEUNIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.temperatureUnitString(), TEMPERATUREUNIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.wakeWordString(), WAKEWORD_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.setupModeDisabled(), SETUPMODEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.maxVolumeLimit(), MAXVOLUMELIMIT_BINDING);
            protocolMarshaller.marshall((Object)createProfileRequest.pstnEnabled(), PSTNENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

