/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;

@SdkInternalApi
public class CreateSkillGroupRequestModelMarshaller {
    private static final MarshallingInfo<String> SKILLGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillGroupName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CreateSkillGroupRequestModelMarshaller INSTANCE = new CreateSkillGroupRequestModelMarshaller();

    public static CreateSkillGroupRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateSkillGroupRequest createSkillGroupRequest, ProtocolMarshaller protocolMarshaller) {
        if (createSkillGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createSkillGroupRequest.skillGroupName(), SKILLGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createSkillGroupRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createSkillGroupRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

