/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceData;

@SdkInternalApi
public class DeviceDataMarshaller {
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").build();
    private static final MarshallingInfo<String> DEVICESERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceSerialNumber").build();
    private static final MarshallingInfo<String> DEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceType").build();
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> SOFTWAREVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SoftwareVersion").build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MacAddress").build();
    private static final MarshallingInfo<String> DEVICESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceStatus").build();
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").build();
    private static final MarshallingInfo<String> ROOMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomName").build();
    private static final DeviceDataMarshaller INSTANCE = new DeviceDataMarshaller();

    public static DeviceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceData deviceData, ProtocolMarshaller protocolMarshaller) {
        if (deviceData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deviceData.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceSerialNumber(), DEVICESERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceType(), DEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)deviceData.softwareVersion(), SOFTWAREVERSION_BINDING);
            protocolMarshaller.marshall((Object)deviceData.macAddress(), MACADDRESS_BINDING);
            protocolMarshaller.marshall((Object)deviceData.deviceStatusString(), DEVICESTATUS_BINDING);
            protocolMarshaller.marshall((Object)deviceData.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)deviceData.roomName(), ROOMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

