/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.Device;

@SdkInternalApi
public class DeviceMarshaller {
    private static final MarshallingInfo<String> DEVICEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceArn").build();
    private static final MarshallingInfo<String> DEVICESERIALNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceSerialNumber").build();
    private static final MarshallingInfo<String> DEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceType").build();
    private static final MarshallingInfo<String> DEVICENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceName").build();
    private static final MarshallingInfo<String> SOFTWAREVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SoftwareVersion").build();
    private static final MarshallingInfo<String> MACADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MacAddress").build();
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").build();
    private static final MarshallingInfo<String> DEVICESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceStatus").build();
    private static final DeviceMarshaller INSTANCE = new DeviceMarshaller();

    public static DeviceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Device device, ProtocolMarshaller protocolMarshaller) {
        if (device == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)device.deviceArn(), DEVICEARN_BINDING);
            protocolMarshaller.marshall((Object)device.deviceSerialNumber(), DEVICESERIALNUMBER_BINDING);
            protocolMarshaller.marshall((Object)device.deviceType(), DEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)device.deviceName(), DEVICENAME_BINDING);
            protocolMarshaller.marshall((Object)device.softwareVersion(), SOFTWAREVERSION_BINDING);
            protocolMarshaller.marshall((Object)device.macAddress(), MACADDRESS_BINDING);
            protocolMarshaller.marshall((Object)device.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)device.deviceStatusString(), DEVICESTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

