/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.Profile;

@SdkInternalApi
public class ProfileMarshaller {
    private static final MarshallingInfo<String> PROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileArn").build();
    private static final MarshallingInfo<String> PROFILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileName").build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").build();
    private static final MarshallingInfo<String> DISTANCEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DistanceUnit").build();
    private static final MarshallingInfo<String> TEMPERATUREUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemperatureUnit").build();
    private static final MarshallingInfo<String> WAKEWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WakeWord").build();
    private static final MarshallingInfo<Boolean> SETUPMODEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SetupModeDisabled").build();
    private static final MarshallingInfo<Integer> MAXVOLUMELIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxVolumeLimit").build();
    private static final MarshallingInfo<Boolean> PSTNENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PSTNEnabled").build();
    private static final ProfileMarshaller INSTANCE = new ProfileMarshaller();

    public static ProfileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Profile profile, ProtocolMarshaller protocolMarshaller) {
        if (profile == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)profile.profileArn(), PROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)profile.profileName(), PROFILENAME_BINDING);
            protocolMarshaller.marshall((Object)profile.address(), ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)profile.timezone(), TIMEZONE_BINDING);
            protocolMarshaller.marshall((Object)profile.distanceUnitString(), DISTANCEUNIT_BINDING);
            protocolMarshaller.marshall((Object)profile.temperatureUnitString(), TEMPERATUREUNIT_BINDING);
            protocolMarshaller.marshall((Object)profile.wakeWordString(), WAKEWORD_BINDING);
            protocolMarshaller.marshall((Object)profile.setupModeDisabled(), SETUPMODEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)profile.maxVolumeLimit(), MAXVOLUMELIMIT_BINDING);
            protocolMarshaller.marshall((Object)profile.pstnEnabled(), PSTNENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

