/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.Room;

@SdkInternalApi
public class RoomMarshaller {
    private static final MarshallingInfo<String> ROOMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomArn").build();
    private static final MarshallingInfo<String> ROOMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoomName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> PROVIDERCALENDARID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderCalendarId").build();
    private static final MarshallingInfo<String> PROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProfileArn").build();
    private static final RoomMarshaller INSTANCE = new RoomMarshaller();

    public static RoomMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Room room, ProtocolMarshaller protocolMarshaller) {
        if (room == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)room.roomArn(), ROOMARN_BINDING);
            protocolMarshaller.marshall((Object)room.roomName(), ROOMNAME_BINDING);
            protocolMarshaller.marshall((Object)room.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)room.providerCalendarId(), PROVIDERCALENDARID_BINDING);
            protocolMarshaller.marshall((Object)room.profileArn(), PROFILEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

