/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary;

@SdkInternalApi
public class SkillSummaryMarshaller {
    private static final MarshallingInfo<String> SKILLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillId").build();
    private static final MarshallingInfo<String> SKILLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkillName").build();
    private static final MarshallingInfo<Boolean> SUPPORTSLINKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportsLinking").build();
    private static final SkillSummaryMarshaller INSTANCE = new SkillSummaryMarshaller();

    public static SkillSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkillSummary skillSummary, ProtocolMarshaller protocolMarshaller) {
        if (skillSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)skillSummary.skillId(), SKILLID_BINDING);
            protocolMarshaller.marshall((Object)skillSummary.skillName(), SKILLNAME_BINDING);
            protocolMarshaller.marshall((Object)skillSummary.supportsLinking(), SUPPORTSLINKING_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

