/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.model.UserData;

@SdkInternalApi
public class UserDataMarshaller {
    private static final MarshallingInfo<String> USERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserArn").build();
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").build();
    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").build();
    private static final MarshallingInfo<String> ENROLLMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnrollmentStatus").build();
    private static final MarshallingInfo<String> ENROLLMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnrollmentId").build();
    private static final UserDataMarshaller INSTANCE = new UserDataMarshaller();

    public static UserDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserData userData, ProtocolMarshaller protocolMarshaller) {
        if (userData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)userData.userArn(), USERARN_BINDING);
            protocolMarshaller.marshall((Object)userData.firstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall((Object)userData.lastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall((Object)userData.email(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)userData.enrollmentStatusString(), ENROLLMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)userData.enrollmentId(), ENROLLMENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

