/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateRoomRequest.Builder, CreateRoomRequest> {
    private final String roomName;

    private final String description;

    private final String profileArn;

    private final String providerCalendarId;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateRoomRequest(BuilderImpl builder) {
        super(builder);
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.profileArn = builder.profileArn;
        this.providerCalendarId = builder.providerCalendarId;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the room.
     * </p>
     * 
     * @return The name for the room.
     */
    public String roomName() {
        return roomName;
    }

    /**
     * <p>
     * The description for the room.
     * </p>
     * 
     * @return The description for the room.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The profile ARN for the room.
     * </p>
     * 
     * @return The profile ARN for the room.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The calendar ARN for the room.
     * </p>
     * 
     * @return The calendar ARN for the room.
     */
    public String providerCalendarId() {
        return providerCalendarId;
    }

    /**
     * <p>
     * A unique, user-specified identifier for this request that ensures idempotency.
     * </p>
     * 
     * @return A unique, user-specified identifier for this request that ensures idempotency.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The tags for the room.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags for the room.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomRequest)) {
            return false;
        }
        CreateRoomRequest other = (CreateRoomRequest) obj;
        return Objects.equals(roomName(), other.roomName()) && Objects.equals(description(), other.description())
                && Objects.equals(profileArn(), other.profileArn())
                && Objects.equals(providerCalendarId(), other.providerCalendarId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRoomRequest").add("RoomName", roomName()).add("Description", description())
                .add("ProfileArn", profileArn()).add("ProviderCalendarId", providerCalendarId())
                .add("ClientRequestToken", clientRequestToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomName":
            return Optional.of(clazz.cast(roomName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ProfileArn":
            return Optional.of(clazz.cast(profileArn()));
        case "ProviderCalendarId":
            return Optional.of(clazz.cast(providerCalendarId()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, CreateRoomRequest> {
        /**
         * <p>
         * The name for the room.
         * </p>
         * 
         * @param roomName
         *        The name for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * The description for the room.
         * </p>
         * 
         * @param description
         *        The description for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The profile ARN for the room.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The calendar ARN for the room.
         * </p>
         * 
         * @param providerCalendarId
         *        The calendar ARN for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerCalendarId(String providerCalendarId);

        /**
         * <p>
         * A unique, user-specified identifier for this request that ensures idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, user-specified identifier for this request that ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags for the room.
         * </p>
         * 
         * @param tags
         *        The tags for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the room.
         * </p>
         * 
         * @param tags
         *        The tags for the room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String roomName;

        private String description;

        private String profileArn;

        private String providerCalendarId;

        private String clientRequestToken;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomRequest model) {
            roomName(model.roomName);
            description(model.description);
            profileArn(model.profileArn);
            providerCalendarId(model.providerCalendarId);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final String getRoomName() {
            return roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProviderCalendarId() {
            return providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRoomRequest build() {
            return new CreateRoomRequest(this);
        }
    }
}
