/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateRoomResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateRoomResponse.Builder, CreateRoomResponse> {
    private final String roomArn;

    private CreateRoomResponse(BuilderImpl builder) {
        super(builder);
        this.roomArn = builder.roomArn;
    }

    /**
     * <p>
     * The ARN of the newly created room in the response.
     * </p>
     * 
     * @return The ARN of the newly created room in the response.
     */
    public String roomArn() {
        return roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomResponse)) {
            return false;
        }
        CreateRoomResponse other = (CreateRoomResponse) obj;
        return Objects.equals(roomArn(), other.roomArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRoomResponse").add("RoomArn", roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.of(clazz.cast(roomArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, CreateRoomResponse> {
        /**
         * <p>
         * The ARN of the newly created room in the response.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the newly created room in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomResponse model) {
            roomArn(model.roomArn);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public CreateRoomResponse build() {
            return new CreateRoomResponse(this);
        }
    }
}
