/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateUserResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateUserResponse.Builder, CreateUserResponse> {
    private final String userArn;

    private CreateUserResponse(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
    }

    /**
     * <p>
     * The ARN of the newly created user in the response.
     * </p>
     * 
     * @return The ARN of the newly created user in the response.
     */
    public String userArn() {
        return userArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserResponse)) {
            return false;
        }
        CreateUserResponse other = (CreateUserResponse) obj;
        return Objects.equals(userArn(), other.userArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateUserResponse").add("UserArn", userArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.of(clazz.cast(userArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, CopyableBuilder<Builder, CreateUserResponse> {
        /**
         * <p>
         * The ARN of the newly created user in the response.
         * </p>
         * 
         * @param userArn
         *        The ARN of the newly created user in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String userArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserResponse model) {
            userArn(model.userArn);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public CreateUserResponse build() {
            return new CreateUserResponse(this);
        }
    }
}
