/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.ProfileDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data of a room profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProfileData implements StructuredPojo, ToCopyableBuilder<ProfileData.Builder, ProfileData> {
    private final String profileArn;

    private final String profileName;

    private final String address;

    private final String timezone;

    private final String distanceUnit;

    private final String temperatureUnit;

    private final String wakeWord;

    private ProfileData(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
    }

    /**
     * <p>
     * The ARN of a room profile.
     * </p>
     * 
     * @return The ARN of a room profile.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The name of a room profile.
     * </p>
     * 
     * @return The name of a room profile.
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The address of a room profile.
     * </p>
     * 
     * @return The address of a room profile.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The timezone of a room profile.
     * </p>
     * 
     * @return The timezone of a room profile.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public String distanceUnitString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(temperatureUnit);
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public String temperatureUnitString() {
        return temperatureUnit;
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public WakeWord wakeWord() {
        return WakeWord.fromValue(wakeWord);
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public String wakeWordString() {
        return wakeWord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(temperatureUnitString());
        hashCode = 31 * hashCode + Objects.hashCode(wakeWordString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileData)) {
            return false;
        }
        ProfileData other = (ProfileData) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName())
                && Objects.equals(address(), other.address()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(distanceUnitString(), other.distanceUnitString())
                && Objects.equals(temperatureUnitString(), other.temperatureUnitString())
                && Objects.equals(wakeWordString(), other.wakeWordString());
    }

    @Override
    public String toString() {
        return ToString.builder("ProfileData").add("ProfileArn", profileArn()).add("ProfileName", profileName())
                .add("Address", address()).add("Timezone", timezone()).add("DistanceUnit", distanceUnitString())
                .add("TemperatureUnit", temperatureUnitString()).add("WakeWord", wakeWordString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.of(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.of(clazz.cast(profileName()));
        case "Address":
            return Optional.of(clazz.cast(address()));
        case "Timezone":
            return Optional.of(clazz.cast(timezone()));
        case "DistanceUnit":
            return Optional.of(clazz.cast(distanceUnitString()));
        case "TemperatureUnit":
            return Optional.of(clazz.cast(temperatureUnitString()));
        case "WakeWord":
            return Optional.of(clazz.cast(wakeWordString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfileDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProfileData> {
        /**
         * <p>
         * The ARN of a room profile.
         * </p>
         * 
         * @param profileArn
         *        The ARN of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The name of a room profile.
         * </p>
         * 
         * @param profileName
         *        The name of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The address of a room profile.
         * </p>
         * 
         * @param address
         *        The address of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The timezone of a room profile.
         * </p>
         * 
         * @param timezone
         *        The timezone of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(String temperatureUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(TemperatureUnit temperatureUnit);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(String wakeWord);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(WakeWord wakeWord);
    }

    static final class BuilderImpl implements Builder {
        private String profileArn;

        private String profileName;

        private String address;

        private String timezone;

        private String distanceUnit;

        private String temperatureUnit;

        private String wakeWord;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileData model) {
            profileArn(model.profileArn);
            profileName(model.profileName);
            address(model.address);
            timezone(model.timezone);
            distanceUnit(model.distanceUnit);
            temperatureUnit(model.temperatureUnit);
            wakeWord(model.wakeWord);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getDistanceUnit() {
            return distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnit() {
            return temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWord() {
            return wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        @Override
        public ProfileData build() {
            return new ProfileData(this);
        }
    }
}
