/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource in the request is already in use. HTTP Status Code: 400
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResourceInUseException extends AlexaForBusinessException implements
        ToCopyableBuilder<ResourceInUseException.Builder, ResourceInUseException> {
    private final String clientRequestToken;

    private ResourceInUseException(BuilderImpl builder) {
        super(builder.message);
        this.clientRequestToken = builder.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    public interface Builder extends CopyableBuilder<Builder, ResourceInUseException> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String clientRequestToken;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceInUseException model) {
            clientRequestToken(model.clientRequestToken);
            this.message = model.getMessage();
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @JsonProperty("ClientRequestToken")
        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ResourceInUseException build() {
            return new ResourceInUseException(this);
        }
    }
}
