/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.RoomDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data of a room.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RoomData implements StructuredPojo, ToCopyableBuilder<RoomData.Builder, RoomData> {
    private final String roomArn;

    private final String roomName;

    private final String description;

    private final String providerCalendarId;

    private final String profileArn;

    private final String profileName;

    private RoomData(BuilderImpl builder) {
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
    }

    /**
     * <p>
     * The ARN of a room.
     * </p>
     * 
     * @return The ARN of a room.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The name of a room.
     * </p>
     * 
     * @return The name of a room.
     */
    public String roomName() {
        return roomName;
    }

    /**
     * <p>
     * The description of a room.
     * </p>
     * 
     * @return The description of a room.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The provider calendar ARN of a room.
     * </p>
     * 
     * @return The provider calendar ARN of a room.
     */
    public String providerCalendarId() {
        return providerCalendarId;
    }

    /**
     * <p>
     * The profile ARN of a room.
     * </p>
     * 
     * @return The profile ARN of a room.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The profile name of a room.
     * </p>
     * 
     * @return The profile name of a room.
     */
    public String profileName() {
        return profileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomData)) {
            return false;
        }
        RoomData other = (RoomData) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(roomName(), other.roomName())
                && Objects.equals(description(), other.description())
                && Objects.equals(providerCalendarId(), other.providerCalendarId())
                && Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName());
    }

    @Override
    public String toString() {
        return ToString.builder("RoomData").add("RoomArn", roomArn()).add("RoomName", roomName())
                .add("Description", description()).add("ProviderCalendarId", providerCalendarId())
                .add("ProfileArn", profileArn()).add("ProfileName", profileName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.of(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.of(clazz.cast(roomName()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ProviderCalendarId":
            return Optional.of(clazz.cast(providerCalendarId()));
        case "ProfileArn":
            return Optional.of(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.of(clazz.cast(profileName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoomDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RoomData> {
        /**
         * <p>
         * The ARN of a room.
         * </p>
         * 
         * @param roomArn
         *        The ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The name of a room.
         * </p>
         * 
         * @param roomName
         *        The name of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * The description of a room.
         * </p>
         * 
         * @param description
         *        The description of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The provider calendar ARN of a room.
         * </p>
         * 
         * @param providerCalendarId
         *        The provider calendar ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerCalendarId(String providerCalendarId);

        /**
         * <p>
         * The profile ARN of a room.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The profile name of a room.
         * </p>
         * 
         * @param profileName
         *        The profile name of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);
    }

    static final class BuilderImpl implements Builder {
        private String roomArn;

        private String roomName;

        private String description;

        private String providerCalendarId;

        private String profileArn;

        private String profileName;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomData model) {
            roomArn(model.roomArn);
            roomName(model.roomName);
            description(model.description);
            providerCalendarId(model.providerCalendarId);
            profileArn(model.profileArn);
            profileName(model.profileName);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderCalendarId() {
            return providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public RoomData build() {
            return new RoomData(this);
        }
    }
}
