/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.alexaforbusiness.transform.RoomSkillParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A skill parameter associated with a room.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RoomSkillParameter implements StructuredPojo, ToCopyableBuilder<RoomSkillParameter.Builder, RoomSkillParameter> {
    private final String parameterKey;

    private final String parameterValue;

    private RoomSkillParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or
     * “SCOPE” as valid values.
     * </p>
     * 
     * @return The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT”
     *         or “SCOPE” as valid values.
     */
    public String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The parameter value of a room skill parameter.
     * </p>
     * 
     * @return The parameter value of a room skill parameter.
     */
    public String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomSkillParameter)) {
            return false;
        }
        RoomSkillParameter other = (RoomSkillParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(parameterValue(), other.parameterValue());
    }

    @Override
    public String toString() {
        return ToString.builder("RoomSkillParameter").add("ParameterKey", parameterKey()).add("ParameterValue", parameterValue())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterKey":
            return Optional.of(clazz.cast(parameterKey()));
        case "ParameterValue":
            return Optional.of(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoomSkillParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RoomSkillParameter> {
        /**
         * <p>
         * The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes “DEFAULT” or
         * “SCOPE” as valid values.
         * </p>
         * 
         * @param parameterKey
         *        The parameter key of a room skill parameter. ParameterKey is an enumerated type that only takes
         *        “DEFAULT” or “SCOPE” as valid values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The parameter value of a room skill parameter.
         * </p>
         * 
         * @param parameterValue
         *        The parameter value of a room skill parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomSkillParameter model) {
            parameterKey(model.parameterKey);
            parameterValue(model.parameterValue);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public RoomSkillParameter build() {
            return new RoomSkillParameter(this);
        }
    }
}
