/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchProfilesRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<SearchProfilesRequest.Builder, SearchProfilesRequest> {
    private final String nextToken;

    private final Integer maxResults;

    private final List<Filter> filters;

    private final List<Sort> sortCriteria;

    private SearchProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * <code>MaxResults</code>.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by <code>MaxResults</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and Address.
     * Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and
     *         Address. Required.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and
     * Address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName
     *         and Address.
     */
    public List<Sort> sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProfilesRequest)) {
            return false;
        }
        SearchProfilesRequest other = (SearchProfilesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(filters(), other.filters()) && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    @Override
    public String toString() {
        return ToString.builder("SearchProfilesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("Filters", filters()).add("SortCriteria", sortCriteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "SortCriteria":
            return Optional.of(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, SearchProfilesRequest> {
        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by <code>MaxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and
         * Address. Required.
         * </p>
         * 
         * @param filters
         *        The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and
         *        Address. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and
         * Address. Required.
         * </p>
         * 
         * @param filters
         *        The filters to use to list a specified set of room profiles. Supported filter keys are ProfileName and
         *        Address. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and
         * Address.
         * </p>
         * 
         * @param sortCriteria
         *        The sort order to use in listing the specified set of room profiles. Supported sort keys are
         *        ProfileName and Address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Collection<Sort> sortCriteria);

        /**
         * <p>
         * The sort order to use in listing the specified set of room profiles. Supported sort keys are ProfileName and
         * Address.
         * </p>
         * 
         * @param sortCriteria
         *        The sort order to use in listing the specified set of room profiles. Supported sort keys are
         *        ProfileName and Address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Sort... sortCriteria);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<Filter> filters;

        private List<Sort> sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProfilesRequest model) {
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
            sortCriteria(model.sortCriteria);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<Sort.Builder> getSortCriteria() {
            return sortCriteria != null ? sortCriteria.stream().map(Sort::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortCriteria(Collection<Sort> sortCriteria) {
            this.sortCriteria = SortListCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Sort... sortCriteria) {
            sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        public final void setSortCriteria(Collection<Sort.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortListCopier.copyFromBuilder(sortCriteria);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SearchProfilesRequest build() {
            return new SearchProfilesRequest(this);
        }
    }
}
